<?php
    $reviews = review($course);
    $translations = parse_translation($course);
?>
<article>
    <h2 class="area-title text-2xl mb-5"><?php echo e($translations['title'] ?? ($course->title ?? '')); ?></h2>
    <div
        class="flex divide-x rtl:divide-x-reverse divide-border space-x-5 rtl:space-x-reverse [&>:not(:first-child)]:pl-5 rtl:[&>:not(:first-child)]:pl-0 rtl:[&>:not(:first-child)]:pr-5">
        <div>
            <div class="flex items-center gap-2.5">
                <div class="flex items-center gap-0.5 text-secondary">
                    <?php echo show_rating($reviews['average_rating']); ?>

                </div>
                <?php if($reviews['average_rating']): ?>
                    <span
                        class="text-heading dark:text-white text-sm font-bold leading-none"><?php echo e(dotZeroRemove($reviews['average_rating'])); ?></span>
                <?php endif; ?>
            </div>

            <div class="text-sm text-heading/60 mt-1">
                <strong><?php echo e($reviews['total_rating'] ?? 0); ?></strong> <?php echo e(translate('Ratings')); ?>

            </div>
        </div>
        <div class="flex flex-col items-start gap-px">
            <div class="text-heading dark:text-white text-sm font-bold leading-none">
                <?php echo e($course?->totalPurchases->count() ?? 0); ?></div>
            <div class="text-sm text-heading/60 mt-1">
                <?php echo e(translate('Students')); ?>

            </div>
        </div>
        <div class="flex flex-col items-start gap-px">
            <div class="text-heading dark:text-white text-sm font-bold leading-none"> <?php echo e($course->duration); ?>

                <?php echo e(translate('Hour')); ?> </div>
            <div class="text-sm text-heading/60 mt-1"><?php echo e(translate('Total')); ?></div>
        </div>
    </div>
    <div class="text-heading dark:text-white text-sm font-bold leading-none mt-5">
        <?php echo e(translate('Last updated')); ?>

        <?php echo e(customDateFormate($course->updated_at, 'd M Y')); ?>

    </div>
</article>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\course\short-info.blade.php ENDPATH**/ ?>