<?php

    $isOrganization = $isOrganization ?? false;
    $isInstructor = $isInstructor ?? false;
    $user = authCheck();
?>

<div class="card">
    <form method="GET">
        <div class="grid grid-cols-4 gap-4">
            <div class="col-span-full sm:col-span-2 xl:col-auto">
                <label class="form-label"><?php echo e(translate('Category')); ?></label>
                <select class="singleSelect selectFilterCategory" name="categories[]" multiple="multiple">
                    <?php $__currentLoopData = get_all_category(type: 'cat'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $categoryTranslations = parse_translation($category);
                        ?>
                        <option value="<?php echo e($category->id); ?>"
                            <?php if(isset(Request()->categories)): ?> <?php $__currentLoopData = Request()->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectCat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($selectCat == $category->id ? 'selected' : ''); ?>

                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                            <?php echo e($categoryTranslations['title'] ?? $category->title); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-span-full sm:col-span-2 xl:col-auto">
                <label class="form-label"><?php echo e(translate('Sub Category')); ?></label>
                <select class="singleSelect selectFilterCategory" name="subcategories[]" multiple="multiple">
                    <?php $__currentLoopData = get_all_category(type: 'sub'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $subCategoryTranslations = parse_translation($subcategory);
                        ?>
                        <option value="<?php echo e($subcategory->id); ?>"
                            <?php if(isset(Request()->subcategories)): ?> <?php $__currentLoopData = Request()->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectCat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($selectCat == $subcategory->id ? 'selected' : ''); ?>

                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                            <?php echo e($subCategoryTranslations['title'] ?? $subcategory->title); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-span-full sm:col-span-2 xl:col-auto">
                <label class="form-label"> <?php echo e(translate('Status')); ?> </label>
                <select class="singleSelect" name="course_status">
                    <?php
                        $courseStatus = Request()->course_status ?? null;
                    ?>
                    <option selected disabled><?php echo e(translate('Select Status')); ?></option>
                    <option value="all" <?php echo e($courseStatus == 'all' ? 'selected' : ''); ?>><?php echo e(translate('All')); ?>

                    </option>
                    <option value="Approved"<?php echo e($courseStatus == 'Approved' ? 'selected' : ''); ?>>
                        <?php echo e(translate('Approved')); ?></option>
                    <option value="Rejected" <?php echo e($courseStatus == 'Rejected' ? 'selected' : ''); ?>>
                        <?php echo e(translate('Rejected')); ?></option>
                    <option value="Pending" <?php echo e($courseStatus == 'Pending' ? 'selected' : ''); ?>>
                        <?php echo e(translate('Pending')); ?></option>
                </select>
            </div>
            <div class="col-span-full sm:col-span-2 xl:col-auto">
                <?php
                    $courseType = Request()->course_type ?? null;
                ?>
                <label class="form-label"> <?php echo e(translate('Course Type')); ?> </label>
                <select class="singleSelect" name="course_type">
                    <option selected disabled><?php echo e(translate('Select Type')); ?></option>
                    <option value="all" <?php echo e($courseType == 'all' ? 'selected' : ''); ?>><?php echo e(translate('All')); ?>

                    </option>
                    <option value="free" <?php echo e($courseType == 'free' ? 'selected' : ''); ?>><?php echo e(translate('Free')); ?>

                    </option>
                    <option value="paid" <?php echo e($courseType == 'paid' ? 'selected' : ''); ?>><?php echo e(translate('Paid')); ?>

                    </option>
                </select>
            </div>
            <?php if(!$isOrganization && !$isInstructor): ?>
                <div class="col-span-full sm:col-span-2 xl:col-auto">
                    <label class="form-label"> <?php echo e(translate('Organization')); ?> </label>
                    <?php
                        $organizations = Request()->organizations ?? null;
                    ?>
                    <select class="singleSelect organization-list" name="organizations">
                        <option disabled selected><?php echo e(translate('Select Organization')); ?></option>
                        <?php $__currentLoopData = get_all_organization(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organization): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $orgTranslations = parse_translation($organization?->userable);
                            ?>
                            <option value="<?php echo e($organization->id); ?>"
                                <?php echo e($organizations == $organization->id ? 'selected' : ''); ?>>
                                <?php echo e($orgTranslations['name'] ?? $organization?->userable?->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            <?php endif; ?>

            <?php if(!$isInstructor): ?>
                <?php
                    $searchInstructors = Request()->instructors ?? [];
                ?>
                <div class="col-span-full sm:col-span-2 xl:col-auto">
                    <label class="form-label"> <?php echo e(translate('Instructor')); ?> </label>
                    <select class="instructor-list selectFilterInstructor" id="instructorOption" multiple="true"
                        name="instructors[]">
                        <?php $__currentLoopData = get_all_instructor($user->id ?? null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $user = $instructor?->userable;
                                $instructorTranslations = parse_translation($user);
                            ?>
                            <option value="<?php echo e($instructor->id); ?>"
                                <?php if($searchInstructors): ?> <?php $__currentLoopData = $searchInstructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $searchInstructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($searchInstructor == $instructor->id ? 'selected' : ''); ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                <?php echo e($instructorTranslations['first_name'] ?? $user?->first_name); ?>

                                <?php echo e($instructorTranslations['last_name'] ?? $user?->last_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

            <?php endif; ?>
            <div class="flex items-end gap-3">
                <button class="btn b-solid btn-info-solid dk-theme-card-square">
                    <?php echo e(translate('Filter')); ?> </button>
                <a href="<?php echo e(Request()->url()); ?>"
                    class="btn b-solid btn-info-solid dk-theme-card-square"><?php echo e(translate('Clear')); ?></a>
            </div>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\filter.blade.php ENDPATH**/ ?>