<?php
    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    $blog = $blog ?? null;
    if ($blog && $locale) {
        $translations = parse_translation($blog, $locale);
    }
?>

<?php if (isset($component)) { $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Dashboard\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Dashboard\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> 
        <?php echo e(isset($blog) ? translate('Edit Blog') : translate('Create Blog')); ?>

     <?php $__env->endSlot(); ?>
    <!-- BREADCRUMB -->
    <?php if (isset($component)) { $__componentOriginalcf27f2c2c873893339708d5fdeeb6984 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.breadcrumb','data' => ['backUrl' => ''.e(route('blog.index')).'','title' => ''.e(isset($blog) ? 'Edit' : 'Create').'','pageTo' => 'Blog']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['back-url' => ''.e(route('blog.index')).'','title' => ''.e(isset($blog) ? 'Edit' : 'Create').'','page-to' => 'Blog']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $attributes = $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $component = $__componentOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>

    <?php if(is_active('blog.translate') === 'active'): ?>
        <div class="flex items-center justify-end gap-4 mb-2">
            <h2 class="card-title"><?php echo e(translate('Translate Language')); ?></h2>
            <form method="GET" class="sm:block" id="change-translate-language">
                <select onchange="window.location.href=this.options[this.selectedIndex].value" name="id"
                    class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-white focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                    <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lang->code); ?>"
                            <?php echo e(isset($locale) && $locale == $lang->code ? 'selected' : ''); ?>>
                            <?php echo e($lang->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
        </div>
    <?php endif; ?>
    <form action="<?php echo e(isset($blog) ? route('blog.update', $blog->id) : route('blog.store')); ?>" method="post"
        class="form" enctype="multipart/form-data">
        <?php if(isset($blog)): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>
        <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full md:col-span-7 card">
                <div>
                    <label for="blog-title" class="form-label"><?php echo e(translate('Blog Title')); ?> <span
                            class="text-danger">*</span> </label>
                    <input type="text" id="blog-title" placeholder="<?php echo e(translate('Title')); ?>" name="title"
                        class="form-input" autocomplete="off"
                        value="<?php echo e($translations['title'] ?? ($blog->title ?? '')); ?>">
                    <span class="text-danger error-text title_err"></span>
                </div>
                <?php if(is_active('blog.translate') !== 'active'): ?>
                    <div class="mt-6">
                        <label class="form-label"><?php echo e(translate('Blog Category')); ?> <span
                                class="text-danger">*</span></label>
                        <select class="multipleSelect" multiple="multiple" name="blog_categoryId[]">
                            <?php $__currentLoopData = get_all_blog_category(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $categoryTranslations = parse_translation($category);  ?>
                                <option value="<?php echo e($category->id); ?>"
                                    <?php if(isset($blog)): ?> <?php $__currentLoopData = $blog->blogCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($blogCategory->id == $category->id ? 'selected' : ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>>
                                    <?php echo e($categoryTranslations['name'] ?? ($category->name ?? '')); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="text-danger error-text blog_categoryId_err"></span>
                    </div>
                <?php endif; ?>
                <div class="mt-6">
                    <label for="blog-content" class="form-label"><?php echo e(translate('Blog Description')); ?> <span
                            class="text-danger">*</span></label>
                    <textarea class="summernote form-input" name="description"> <?php echo clean($translations['description'] ?? ($blog->description ?? '')); ?></textarea>
                    <span class="text-danger error-text description_err"></span>
                </div>
            </div>
            <?php if(is_active('blog.translate') !== 'active'): ?>
                <div class="col-span-full md:col-span-5 card">
                    <h6 class="leading-none text-xl font-semibold text-heading">
                        <?php echo e(translate('Media')); ?>

                    </h6>
                    <div class="mt-7">
                        <p class="text-xs text-gray-500 dark:text-dark-text leading-none font-semibold mb-3">
                            <?php echo e(translate('Image')); ?> <span class="text-danger">*</span>
                        </p>
                        <label for="imgage"
                            class="dropzone-wrappe file-container ac-bg text-xs leading-none font-semibold mb-3 cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10 dk-theme-card-square">
                            <input type="file" hidden name="image" id="imgage"
                                class="dropzone dropzone-image img-src peer/file">
                            <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                                <img src="<?php echo e(asset('lms/')); ?>/assets/images/icons/upload-file.svg" alt="file-icon"
                                    class="size-8 lg:size-auto">
                                <div class="text-gray-500 dark:text-dark-text mt-2">
                                    <?php echo e(translate('Choose file')); ?>

                                </div>
                            </span>
                            <span class="text-danger error-text image_err"></span>
                        </label>
                        <div class="preview-zone dropzone-preview">
                            <div class="box box-solid">
                                <div class="box-body flex items-center gap-2 flex-wrap">

                                    <?php if(isset($blog) && fileExists('lms/blogs', $blog->thumbnail) == true && $blog->thumbnail != ''): ?>
                                        <div class="img-thumb-wrapper"> <button class="remove">
                                                <i class="ri-close-line text-inherit text-[13px]"></i> </button>
                                            <img class="img-thumb" width="100"
                                                src="<?php echo e(asset('storage/lms/blogs/' . $blog->thumbnail)); ?>" />
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="col-span-full card flex justify-end">
                <button type="submit" class="btn b-solid btn-primary-solid w-max dk-theme-card-square">
                    <?php echo e(isset($blog) ? translate('Update') : translate('Save')); ?>

                </button>
            </div>
        </div>
    </form>

    <?php $__env->startPush('js'); ?>
        <script>
            $('.multipleSelect').select2({
                placeholder: "<?php echo e(translate('Select Blog Category')); ?>",
                width: "100%"
            })
        </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $attributes = $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $component = $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\blog\create.blade.php ENDPATH**/ ?>