<!-- Course Meeting Provider -->
<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="meet-provider">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" value="<?php echo e($course->id ?? ''); ?>">

        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full lg:col-span-6 card">
                <h6 class="text-xl font-semibold text-heading"> <?php echo e(translate('Manage Meeting')); ?> </h6>
                <div class="mt-8">
                    <label for="courseCategory" class="form-label"> <?php echo e(translate('Meeting Provider')); ?> </label>
                    <select class="singleSelect" name="meet_provider_id">
                        <option selected disabled> <?php echo e(translate('Select meeting provider')); ?> </option>
                        <?php $__currentLoopData = get_all_mprovider(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mprovider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($mprovider->id); ?>"
                                <?php echo e(isset($course) && $course?->meetProvider?->meet_provider_id == $mprovider->id ? 'selected' : ''); ?>>
                                <?php echo e($mprovider->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mt-4">
                    <label for="meeting-id" class="form-label"> <?php echo e(translate('Meeting Id')); ?> </label>
                    <input type="text" id="meeting-id" placeholder="<?php echo e(translate('Enter Meeting Id')); ?>"
                        name="meeting_id" class="form-input" value="<?php echo e($course?->meetProvider?->meeting_id ?? ''); ?>">
                </div>
                <div class="mt-4">
                    <label for="maderator-password" class="form-label"> <?php echo e(translate('Moderator password')); ?> </label>
                    <div class="relative">
                        <input type="password" id="maderator-password" name="moderator_pw"
                            placeholder="<?php echo e(translate('Enter Moderator Password')); ?>" class="form-input"
                            value="<?php echo e($course?->meetProvider?->moderator_pw ?? ''); ?>">
                        <label for="toggleInputType"
                            class="size-8 rounded-md flex-center hover:bg-gray-200 focus:bg-gray-200 position-center left-[calc(100%_-_23px)]">
                            <input type="checkbox" id="toggleInputType" class="inputTypeToggle peer/it" hidden> <i
                                class="ri-eye-off-line text-gray-500 dark:text-dark-text peer-checked/it:before:content-['\ecb5']"></i>
                        </label>
                    </div>
                </div>
            </div>
            <div class="col-span-full lg:col-span-6 card">
                <h6 class="text-xl font-semibold text-heading"> <?php echo e(translate('Set Meeting Time')); ?> </h6>
                <div class="mt-8">
                    <div class="mt-4">
                        <label class="form-label"> <?php echo e(translate('Schedule Date')); ?> </label>
                        <input type="text" class="form-input" id="scheduleDate" name="class_schedule_date"
                            placeholder="<?php echo e(translate('Please select Date')); ?>"
                            value="<?php echo e($course?->meetProvider?->class_schedule_date ?? ''); ?>">
                    </div>
                    <div class="mt-4">
                        <label class="form-label"><?php echo e(translate('Schedule Time')); ?></label>
                        <input type="text" class="form-input" name="class_schedule_time" id="scheduleTime"
                            placeholder="<?php echo e(translate('Please select Time')); ?>"
                            value="<?php echo e($course?->meetProvider?->class_schedule_time ?? ''); ?>">
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <h6 class="text-xl font-semibold text-heading">
                <?php echo e(translate('Instruction for students')); ?>

            </h6>
            <div class="mt-5">
                <textarea class="summernote" name="instruction"><?php echo clean($course?->meetProvider?->instruction ?? ''); ?></textarea>
            </div>
        </div>
        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\meeting-form.blade.php ENDPATH**/ ?>