<?php
    $categories = $categories ?? [];
    $totalCategories = count( $categories );

    $categoryRoute = '';
    $categoryBtnText = '';

    if (  $totalCategories > 0 ) {
        $categoryRoute = 'category.list';
        $categoryBtnText = 'View All Category';
    }

    if (isAdmin() &&  $totalCategories < 1) {
        $categoryRoute = 'category.create';
        $categoryBtnText = 'Add Category';
    }
?>
<div class="bg-white pt-10 xl:pt-0 pb-16 sm:pb-24 lg:pb-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full md:col-span-7 xl:col-span-6 md:pr-20">
                <div class="area-subtitle">
                    <?php echo e(translate('Top Category')); ?>

                </div>
                <h2 class="area-title mt-2">
                    <?php echo e(translate('Optimize Your Brain for Peak')); ?>

                    <span class="title-highlight-one">
                        <?php echo e(translate('Performance')); ?>

                    </span>
                </h2>
            </div>
            
            <?php if( $categoryRoute && $categoryBtnText): ?>
            <div class="col-span-full md:col-span-5 xl:col-span-6 md:justify-self-end">
                <a href="<?php echo e(route( $categoryRoute )); ?>"
                    title="<?php echo e($categoryBtnText); ?>"
                    aria-label="<?php echo e($categoryBtnText); ?>"
                    class="btn b-solid btn-primary-solid btn-xl !rounded-full font-medium text-[16px] md:text-[18px]">
                    <?php echo e(translate($categoryBtnText)); ?>

                    <span class="hidden md:block">
                        <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                    </span>
                </a>
            </div>
            <?php endif; ?>

        </div>
        <!-- BODY -->
        <?php if(!empty($categories) && is_iterable($categories)): ?>
            <div class="grid grid-cols-12 gap-4 xl:gap-7 mt-10 lg:mt-[60px]">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (isset($component)) { $__componentOriginalaa25689d5d35c523fb12bc4bd25b9d63 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa25689d5d35c523fb12bc4bd25b9d63 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.category.card-one','data' => ['category' => $category]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.category.card-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['category' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($category)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa25689d5d35c523fb12bc4bd25b9d63)): ?>
<?php $attributes = $__attributesOriginalaa25689d5d35c523fb12bc4bd25b9d63; ?>
<?php unset($__attributesOriginalaa25689d5d35c523fb12bc4bd25b9d63); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa25689d5d35c523fb12bc4bd25b9d63)): ?>
<?php $component = $__componentOriginalaa25689d5d35c523fb12bc4bd25b9d63; ?>
<?php unset($__componentOriginalaa25689d5d35c523fb12bc4bd25b9d63); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\category\top-category.blade.php ENDPATH**/ ?>