<?php
    $thumbnail =
        $course->thumbnail && fileExists('lms/courses/thumbnails', $course->thumbnail) == true
            ? asset("storage/lms/courses/thumbnails/{$course->thumbnail}")
            : asset('lms/frontend/assets/images/420x252.svg');

    $currency = $course?->coursePrice->currency ?? 'USD-$';
    $currencySymbol = get_currency_symbol($currency);
?>

<div class="col-span-full lg:col-span-4">
    <div class="bg-primary-50 p-6 rounded-2xl">
        <div data-modal-id="demo-video-modal"
            class="flex-center relative cursor-pointer w-full aspect-video rounded-2xl overflow-hidden">
            <img data-src="<?php echo e($thumbnail); ?>" alt="Course thumbnail" class="size-full object-cover">
            <!-- CONTROLLER -->
            <div class="flex-center size-full bg-[#D9D9D9]/30 rounded-2xl absolute inset-0 [&.hide]:invisible">
                <button type="button" aria-label="Open demo video modal button"
                    class="btn-icon size-9 b-solid btn-secondary-icon-solid !text-heading dark:text-white pulse-animation active:scale-105">
                    <i class="ri-play-fill text-base"></i>
                </button>
            </div>
        </div>
        <table class="w-full mt-7">
            <caption class="area-title text-xl text-left rtl:text-right"> <?php echo e(translate('This Course Includes')); ?>:
            </caption>
            <tbody class="divide-y divide-border mt-1">
                <tr>
                    <td class="px-1 py-4 text-left rtl:text-right">
                        <div class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                            <i class="ri-time-line"></i>
                            <span class="text-heading dark:text-white mb-0.5"> <?php echo e(translate('Duration')); ?> </span>
                        </div>
                    </td>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <div class="text-heading dark:text-white font-semibold leading-none"><?php echo e($course->duration); ?>

                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="px-1 py-4 text-left rtl:text-right">
                        <div class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                            <i class="ri-bar-chart-2-line"></i>
                            <span class="text-heading dark:text-white mb-0.5">
                                <?php echo e(translate('Course Level')); ?>

                            </span>
                        </div>
                    </td>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <div class="text-heading dark:text-white font-semibold leading-none">
                            <?php $__currentLoopData = $course->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $levelTranslations = parse_translation($level); ?>
                                <?php echo e($levelTranslations['name'] ?? ($level->name ?? '')); ?>

                                <?php if(!$loop->first): ?>
                                    ,
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="px-1 py-4 text-left rtl:text-right">
                        <div class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                            <i class="ri-book-line"></i>
                            <span class="text-heading dark:text-white mb-0.5">
                                <?php echo e(translate('Lessons')); ?>

                            </span>
                        </div>
                    </td>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <div class="text-heading dark:text-white font-semibold leading-none">
                            <?php echo e(count($course?->chapters)); ?></div>
                    </td>
                </tr>
                <?php if(isset($course->courseTags) && !empty($course->courseTags)): ?>
                    <tr>
                        <td class="px-1 py-4 text-left rtl:text-right">
                            <div
                                class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                                <i class="ri-price-tag-3-line"></i>
                                <span class="text-heading dark:text-white mb-0.5">
                                    <?php echo e(translate('Tags')); ?>

                                </span>
                            </div>
                        </td>
                        <td class="px-1 py-4 text-right rtl:text-left">
                            <div class="text-heading dark:text-white font-semibold leading-none">
                                <?php $__currentLoopData = $course->courseTags->take(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseTag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $tagTranslations = parse_translation($courseTag); ?>
                                    <?php echo e($tagTranslations['name'] ?? $courseTag->name); ?>

                                    <?php if(!$loop->last): ?>
                                        ,
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
                <?php if(isset($course->languages) && !empty($course->languages)): ?>
                    <tr>
                        <td class="px-1 py-4 text-left rtl:text-right">
                            <div
                                class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                                <i class="ri-global-line"></i>
                                <span class="text-heading dark:text-white mb-0.5">
                                    <?php echo e(translate('Language')); ?>

                                </span>
                            </div>
                        </td>
                        <td class="px-1 py-4 text-right rtl:text-left">
                            <div class="text-heading dark:text-white font-semibold leading-none">
                                <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($language->name); ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
                <?php if($course?->courseSetting?->is_certificate): ?>
                    <tr>
                        <td class="px-1 py-4 text-left rtl:text-right">
                            <div
                                class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                                <i class="ri-award-line"></i>
                                <span class="text-heading dark:text-white mb-0.5">
                                    <?php echo e(translate('Certificate')); ?>

                                </span>
                            </div>
                        </td>
                        <td class="px-1 py-4 text-right rtl:text-left">
                            <div class="text-heading dark:text-white font-semibold leading-none">
                                <?php echo e(translate('Yes')); ?>

                            </div>
                        </td>
                    </tr>
                <?php endif; ?>

                <tr>
                    <td class="px-1 py-4 text-left rtl:text-right">
                        <div class="flex items-center gap-2 area-description text-heading/70 !leading-none shrink-0">
                            <span class="text-heading dark:text-white text-lg font-bold mb-0.5">
                                <?php echo e(translate('Price')); ?>

                            </span>
                        </div>
                    </td>
                    <td class="px-1 py-4 text-right rtl:text-left">
                        <?php if($course?->courseSetting?->is_free == 1): ?>
                            <div
                                class="text-primary text-xl !leading-none font-bold text-right shrink-0 flex items-center justify-end gap-1.5">
                                <span>
                                    <?php echo e(translate('Free')); ?>

                                </span>
                            </div>
                        <?php else: ?>
                            <div
                                class="text-primary text-xl !leading-none font-bold text-right shrink-0 flex items-center justify-end gap-1.5">
                                <?php if(isset($course?->coursePrice) &&
                                        $course?->coursePrice?->discount_flag == 1 &&
                                        $course?->coursePrice?->discount_period != '' &&
                                        dateCompare($course?->coursePrice?->discount_period) == true): ?>
                                    <span><?php echo e($currencySymbol); ?><?php echo e(dotZeroRemove($course?->coursePrice?->discounted_price ?? 0)); ?></span>
                                    <span>
                                        <del
                                            class="text-heading/50 text-[16px] font-semibold"><?php echo e($currencySymbol); ?><?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?></del>
                                    </span>
                                <?php else: ?>
                                    <span><?php echo e($currencySymbol); ?><?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>


        <?php if($purchaseCheck !== true): ?>
            <?php if(is_free($course->id, 'course')): ?>
                <form action="<?php echo e(route('course.enrolled')); ?>" class="form" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" value="<?php echo e($course->id); ?>" name="id">
                    <input type="hidden" value="course" name="type">
                    <?php if(auth()->guard()->check()): ?>
                        <?php if($course?->courseSetting?->is_upcoming): ?>
                            <div class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12">
                                <?php echo e(translate('Up Coming')); ?></div>
                        <?php else: ?>
                            <button type="submit" aria-label="Enroll the Course"
                                class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12">
                                <?php echo e(translate('Enroll the Course')); ?>

                                <i class="ri-arrow-right-line rtl:before:content-['\ea60'] text-inherit"></i>
                            </button>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if(auth()->guard()->guest()): ?>
                        <?php if($course?->courseSetting?->is_upcoming): ?>
                            <div class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12">
                                <?php echo e(translate('Up Coming')); ?></div>
                        <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>"
                                class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12"
                                aria-label="Enroll the Course">
                                <?php echo e(translate('Enroll the Course')); ?>

                                <span class="hidden md:block">
                                    <i class="ri-arrow-right-up-line text-[20px] rtl:before:content-['\ea66']"></i>
                                </span>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </form>
            <?php else: ?>
                <?php if($course?->courseSetting?->is_upcoming): ?>
                    <div class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12">
                        <?php echo e(translate('Up Coming')); ?></div>
                <?php else: ?>
                    <button type="button" aria-label="Enroll the Course"
                        class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12 add-to-cart"
                        data-course-id="<?php echo e($course->id); ?>" data-type="course">
                        <?php echo e(translate('Add To Cart')); ?>

                        <i class="ri-arrow-right-line rtl:before:content-['\ea60'] text-inherit"></i>
                    </button>
                <?php endif; ?>

            <?php endif; ?>
        <?php else: ?>
            <a class="btn b-solid btn-primary-solid btn-xl font-medium !rounded-full w-full h-12"
                aria-label="Go to Course video" href="<?php echo e(route('play.course', $course?->slug)); ?>">
                <?php echo e(translate('Go to Learn')); ?>

                <i class="ri-arrow-right-line rtl:before:content-['\ea60'] text-inherit"></i>
            </a>
        <?php endif; ?>
    </div>
</div>

<!-- START DEMO VIDEO MODAL -->
<?php if (isset($component)) { $__componentOriginalacc4271ed1b09f228b3bd9f3418fce57 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalacc4271ed1b09f228b3bd9f3418fce57 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::course.details.demo-video','data' => ['course' => $course]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::course.details.demo-video'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['course' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($course)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalacc4271ed1b09f228b3bd9f3418fce57)): ?>
<?php $attributes = $__attributesOriginalacc4271ed1b09f228b3bd9f3418fce57; ?>
<?php unset($__attributesOriginalacc4271ed1b09f228b3bd9f3418fce57); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalacc4271ed1b09f228b3bd9f3418fce57)): ?>
<?php $component = $__componentOriginalacc4271ed1b09f228b3bd9f3418fce57; ?>
<?php unset($__componentOriginalacc4271ed1b09f228b3bd9f3418fce57); ?>
<?php endif; ?>
<!-- END DEMO VIDEO MODAL -->
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\course\details\sidebar.blade.php ENDPATH**/ ?>