<?php
    $thumbnail =
        $enrolled?->courseBundle?->thumbnail &&
        fileExists('lms/courses/bundles', $enrolled?->courseBundle?->thumbnail) == true
            ? asset('storage/lms/courses/bundles/' . $enrolled?->courseBundle?->thumbnail)
            : asset('lms/assets/images/placeholder/thumbnail612.jpg');
?>
<tr>
    <td class="px-3.5 py-4">
        <div class="flex items-center gap-2">
            <a href="<?php echo e(route('course.bundle')); ?>" class="size-[70px] rounded-50 overflow-hidden dk-theme-card-square">
                <img src="<?php echo e($thumbnail); ?>" alt="thumb" class="size-full object-cover">
            </a>
            <h6 class="text-lg leading-none text-heading dark:text-white font-bold mb-1.5 line-clamp-1">
                <a href="<?php echo e(route('course.bundle')); ?>" target="_blank">
                    <?php echo e($enrolled?->courseBundle?->title); ?></a>
            </h6>
        </div>
    </td>
    <td class="px-3.5 py-4">
        <?php echo e(translate('Bundle')); ?>

    </td>
    <td class="px-3.5 py-4">
        <?php if($enrolled?->courseBundle?->price !== 0): ?>
            $<?php echo e($enrolled?->courseBundle?->price); ?>

        <?php else: ?>
            <?php echo e(translate('Free')); ?>

        <?php endif; ?>
    </td>
    <td class="px-3.5 py-4">
        <?php switch($enrolled->status):
            case ('processing'): ?>
                <span class="badge badge-warning-outline b-outline capitalize">
                    <?php echo e(translate('Processing')); ?>

                </span>
            <?php break; ?>

            <?php case ('complete'): ?>
                <span class="badge badge-primary-outline b-outline capitalize">
                    <?php echo e(translate('Complete')); ?>

                </span>
            <?php break; ?>
        <?php endswitch; ?>
    </td>
</tr>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\student\enrolled-bundle.blade.php ENDPATH**/ ?>