<?php

    $isOrganization = isOrganization();
    $isInstructor = isInstructor();
    $user = authCheck();

?>



<div class="fieldset !block">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="basic">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($user?->userable?->id ?? null); ?>">

        <?php if($isOrganization): ?>
            <input type="hidden" name="type" value="organization">
        <?php elseif($isInstructor): ?>
            <input type="hidden" name="type" value="instructor">
        <?php endif; ?>

        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full lg:col-span-6 card">
                <?php if(!$isOrganization): ?>
                    <div class="">
                        <label for="firstName" class="form-label mb-2 d-block">
                            <?php echo e(translate('First Name')); ?>

                            <span class="text-danger">*</span>
                        </label>
                        <input type="text" id="firstName" name="first_name"
                            placeholder="<?php echo e(translate('Enter First Name')); ?>"
                            value="<?php echo e($user?->userable?->first_name); ?>" class="form-input" autocomplete="off">

                        <span class="text-danger error-text first_name_err"></span>
                    </div>
                    <div class="mt-6">
                        <label for="lastname" class="form-label mb-2 d-block"> <?php echo e(translate('Last Name')); ?> </label>

                        <input type="text" id="lastname" name="last_name"
                            placeholder="<?php echo e(translate('Enter Last Name')); ?>" class="form-input" autocomplete="off"
                            value="<?php echo e($user?->userable?->last_name); ?>">
                        <span class="text-danger error-text last_name_err"></span>
                    </div>
                <?php else: ?>
                    <div class="mt-6">
                        <label for="name" class="form-label mb-2 d-block">
                            <?php echo e(translate('Organization Name')); ?>

                            <span class="text-danger">*</span>
                        </label>
                        <input type="text" id="name" name="name"
                            placeholder="<?php echo e(translate('Enter Organization Name')); ?>"
                            value="<?php echo e($user?->userable?->name); ?>" class="form-input" autocomplete="off">
                        <span class="text-danger error-text name_err"></span>
                    </div>
                <?php endif; ?>
                <div class="mt-6">
                    <label for="email" class="form-label mb-2 d-block">
                        <?php echo e(translate('Email')); ?> <span class="text-danger">*</span>
                    </label>
                    <input type="text" id="email" name="email" placeholder="<?php echo e(translate('Enter Email')); ?>"
                        class="form-input" autocomplete="off" readonly value="<?php echo e($user?->email ?? ''); ?>">

                </div>
                <div class="mt-6">
                    <label for="phone" class="form-label mb-2 d-block"> <?php echo e(translate('Phone')); ?> <span
                            class="text-danger">*</span></label>
                    <input type="text" id="phone" name="phone" placeholder="<?php echo e(translate('Enter Phone')); ?>"
                        class="form-input" autocomplete="off" value="<?php echo e($user?->userable?->phone ?? ''); ?>">
                    <span class="text-danger error-text phone_err"></span>
                </div>
            </div>
            <div class="col-span-full lg:col-span-6 card">
                <div class="">
                    <label class="form-label mb-2 d-block"> <?php echo e(translate('Language')); ?> </label>
                    <select class="singleSelect" name="language_id">
                        <option selected disabled><?php echo e(translate('Select Language')); ?></option>
                        <?php $__currentLoopData = get_all_language(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($language->id); ?>"
                                <?php echo e($user?->userable?->language_id == $language->id ? 'selected' : ''); ?>>
                                <?php echo e($language->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mt-6">
                    <label class="form-label mb-2 d-block"> <?php echo e(translate('Time Zone')); ?></label>
                    <select class="singleSelect" name="time_zone_id">
                        <option selected disabled> <?php echo e(translate('Select Time Zone')); ?> </option>
                        <?php $__currentLoopData = get_all_zones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($zone->id); ?>"
                                <?php echo e($user?->userable?->time_zone_id == $zone->id ? 'selected' : ''); ?>>
                                <?php echo e($zone->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mt-6">
                    <label for="password" class="form-label mb-2 d-block"> <?php echo e(translate('Password')); ?> <span
                            class="text-danger">*</span></label>
                    <div class="relative">
                        <input type="password" id="password" name="password"
                            placeholder="<?php echo e(translate('Enter Password')); ?>" class="form-input" autocomplete="off">
                        <label for="toggle_password"
                            class="size-8 rounded-md flex-center hover:bg-gray-200 focus:bg-gray-200 position-center left-[calc(100%_-_24px)]">
                            <input type="checkbox" id="toggle_password" class="inputTypeToggle peer/it" hidden>
                            <i
                                class="ri-eye-off-line text-gray-500 dark:text-dark-text peer-checked/it:before:content-['\ecb5']"></i>
                        </label>
                        <span class="text-danger error-text password_err"></span>
                    </div>
                </div>
                <div class="mt-6">
                    <label for="confirmation" class="form-label mb-2 d-block"> <?php echo e(translate('Confirm Password')); ?>

                        <span class="text-danger">*</span></label>
                    <div class="relative">
                        <input type="password" id="confirmation" name="password_confirmation"
                            placeholder="<?php echo e(translate('Confirm Password')); ?>" class="form-input" autocomplete="off">
                        <label for="toggle_confirm_password"
                            class="size-8 rounded-md flex-center hover:bg-gray-200 focus:bg-gray-200 position-center left-[calc(100%_-_24px)]">
                            <input type="checkbox" id="toggle_confirm_password" class="inputTypeToggle peer/it"
                                hidden>
                            <i
                                class="ri-eye-off-line text-gray-500 dark:text-dark-text peer-checked/it:before:content-['\ecb5']"></i>
                        </label>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <label class="form-label d-block"> <?php echo e(translate('About Your self')); ?> </label>
            <textarea name="about" class="summernote form-input"><?php echo clean($user?->userable?->about ?? ''); ?></textarea>
        </div>
        <div class="card flex justify-end gap-2">
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\profile\basic-form.blade.php ENDPATH**/ ?>