<div class="overflow-x-auto scrollbar-table">
    <table
        class="table-auto w-full whitespace-nowrap text-left text-gray-500 dark:text-dark-text font-medium leading-none">
        <thead class="text-primary-500">
            <tr>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Title/Course')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Deadline')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Total Mark')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Pass Mark')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Your Mark')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Attempts')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Date')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Status')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right w-10">
                    <?php echo e(translate('Action')); ?>

                </th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200 dark:divide-dark-border-three">
            <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="px-3.5 py-4">
                        <h6 class="leading-none text-heading dark:text-dark-text font-bold mb-1.5 line-clamp-1">
                            <?php echo e($assignment?->assignment?->title ?? null); ?>

                        </h6>
                        <p class="text-sm dark:text-dark-text-two"><?php echo e($assignment?->course?->title ?? null); ?></p>
                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e(customDateFormate($assignment?->assignment?->submission_date)); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e($assignment?->assignment?->total_mark); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e($assignment?->assignment?->pass_mark); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e($assignment->score); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e($assignment?->attempt_number); ?> / <?php echo e($assignment?->assignment?->retake_number); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e(customDateFormate($assignment->created_at, format: 'm D  Y')); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php if($assignment?->assignment?->pass_mark <= $assignment->score): ?>
                            <span class="badge b-solid badge-success-solid"><?php echo e(translate('Pass')); ?></span>
                        <?php else: ?>
                            <?php if($assignment->score == null): ?>
                                <span class="badge b-solid badge-warning-solid"><?php echo e(translate('Pending')); ?></span>
                            <?php else: ?>
                                <span class="badge b-solid badge-danger-solid"><?php echo e(translate('Failed')); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                    <td class="px-3.5 py-4">
                        <div class="flex items-center gap-1">
                            <a href="<?php echo e(route('exam.start', ['type' => $assignment->exam_type, 'exam_type_id' => $assignment->assignment_id, 'course_id' => $assignment->course_id])); ?>"
                                class="btn b-solid btn-info-solid btn-sm" title="<?php echo e(translate('View Result')); ?>">
                                <?php echo e(translate('View Result')); ?>

                            </a>
                            <a href="<?php echo e(route('course.detail', $assignment?->course?->slug)); ?>"
                                class="btn b-solid btn-info-solid btn-sm" title="<?php echo e(translate('Go Course')); ?>">
                                <?php echo e(translate('Go Course')); ?>

                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\exam\assignment\index.blade.php ENDPATH**/ ?>