<?php
    $translations = [];
    $userInfo = $user?->userable;
    if ($userInfo) {
        $translations = parse_translation($userInfo);
    }

    $countryTranslations = parse_translation($userInfo?->country);
    $stateTranslations = parse_translation($userInfo?->state);
    $cityTranslations = parse_translation($userInfo?->city);
?>

<div class="grid grid-cols-12 gap-x-4">
    <!-- Start Account Setting Form -->
    <div class="col-span-full sm:col-span-6 xl:col-span-8">

        <!-- Basic Information -->
        <div class="card overflow-hidden">
            <div class="px-4 md:p-6 !py-2 bg-gray-200/30 dark:bg-dark-card-two">
                <h6 class="card-title text-lg"><?php echo e(translate('Basic Information')); ?></h6>
            </div>
            <div class="p-3 md:p-6">
                <div class="grid grid-cols-2 gap-x-4 gap-y-5">
                    <?php if($user->guard == 'organization'): ?>
                        <div class="col-span-full xl:col-auto leading-none">
                            <h6 class="text-heading dark:text-white font-semibold">
                                <?php echo e(translate('Organization Name')); ?>:
                                <span class="font-normal text-gray-500 dark:text-dark-text">
                                    <?php echo e($translations['name'] ?? $userInfo?->name); ?>

                                </span>
                            </h6>
                        </div>
                    <?php else: ?>
                        <div class="col-span-full xl:col-auto leading-none">
                            <h6 class="text-heading dark:text-white font-semibold">
                                <?php echo e(translate('Full Name')); ?>:
                                <span class="font-normal text-gray-500 dark:text-dark-text">
                                    <?php echo e(($translations['first_name'] ?? $userInfo?->first_name) . ' ' . ($translations['last_name'] ?? $userInfo?->last_name)); ?>

                                </span>
                            </h6>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- Biography -->
        <div class="card overflow-hidden">
            <div class="px-4 md:p-6 !py-2 bg-gray-200/30 dark:bg-dark-card-two">
                <h6 class="card-title text-lg"><?php echo e(translate('Biography')); ?></h6>
            </div>
            <div class="p-3 md:p-6">
                <div class="grid grid-cols-2 gap-x-4 gap-y-5">
                    <div class="col-span-full">
                        <h6 class="text-heading dark:text-white font-semibold">
                            <?php echo e(translate('Bio')); ?>:
                            <span class="font-normal text-gray-500 dark:text-dark-text">
                                <?php echo clean($translations['about'] ?? $userInfo?->about); ?>

                            </span>
                        </h6>
                    </div>
                </div>
            </div>
        </div>
        <!-- Address -->
        <div class="card overflow-hidden">
            <div class="px-4 md:p-6 !py-2 bg-gray-200/30 dark:bg-dark-card-two">
                <h6 class="card-title text-lg"><?php echo e(translate('Address')); ?></h6>
            </div>
            <div class="p-3 md:p-6">
                <div class="grid grid-cols-2 gap-x-4 gap-y-5">
                    <div class="col-span-full xl:col-auto leading-none">
                        <h6 class="text-heading dark:text-white font-semibold">
                            <?php echo e(translate('Country')); ?> :
                            <span class="font-normal text-gray-500 dark:text-dark-text">
                                <?php echo e($countryTranslations['name'] ?? $userInfo?->country?->name); ?>

                            </span>
                        </h6>
                    </div>
                    <div class="col-span-full xl:col-auto leading-none">
                        <h6 class="text-heading dark:text-white font-semibold">
                            <?php echo e(translate('State')); ?>

                            <span class="font-normal text-gray-500 dark:text-dark-text">
                                <?php echo e($stateTranslations['name'] ?? $userInfo?->state?->name); ?>

                            </span>
                        </h6>
                    </div>
                    <div class="col-span-full xl:col-auto leading-none">
                        <h6 class="text-heading dark:text-white font-semibold">
                            <?php echo e(translate('City')); ?> :
                            <span class="font-normal text-gray-500 dark:text-dark-text">
                                <?php echo e($cityTranslations['name'] ?? $userInfo?->city?->name); ?>

                            </span>
                        </h6>
                    </div>

                    <?php if($userInfo?->location): ?>
                        <div class="col-span-full xl:col-auto leading-none">
                            <h6 class="text-heading dark:text-white font-semibold">
                                <?php echo e(translate('Address')); ?> :
                                <span class="font-normal text-gray-500 dark:text-dark-text">
                                    <?php echo e($translations['location'] ?? $userInfo?->location); ?>

                                </span>
                            </h6>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php if(isset($user->educations) && $user->educations->count() > 0): ?>
            <div class="card overflow-hidden">
                <div class="px-4 md:p-6 !py-2 bg-gray-200/30 dark:bg-dark-card-two">
                    <div class="flex-center-between">
                        <h6 class="card-title text-lg"><?php echo e(translate('Education')); ?></h6>
                    </div>
                </div>

                <div class="p-3 md:p-6">
                    <div class="overflow-x-auto scrollbar-table">
                        <table
                            class="table-auto border-collapse w-full whitespace-nowrap text-sm text-left text-gray-500 dark:text-dark-text font-medium">
                            <thead>
                                <tr class="text-primary-500">
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('Institute')); ?>

                                    </th>
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('Achievement')); ?>

                                    </th>
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('Department')); ?>

                                    </th>
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('Passing Year')); ?>

                                    </th>

                                </tr>
                            </thead>
                            <tbody
                                class="divide-y divide-gray-200 dark:divide-dark-border-three dark:divide-dark-border-three">
                                <?php $__currentLoopData = $user->educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="p-6 py-4"><?php echo e($education->name ?? ''); ?></td>
                                        <td class="p-6 py-4"><?php echo e($education?->pivot?->degree ?? ''); ?></td>
                                        <td class="p-6 py-4"> <?php echo e($education?->pivot?->department ?? ''); ?></td>
                                        <td class="p-6 py-4">"<?php echo e($education?->pivot?->passing_year ?? ''); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        <?php endif; ?>

        <?php if(isset($user->experiences) && $user->experiences->count() > 0): ?>
            <!-- Experience -->
            <div class="card overflow-hidden">
                <div class="px-4 md:p-6 !py-2 bg-gray-200/30 dark:bg-dark-card-two">
                    <div class="flex-center-between">
                        <h6 class="card-title text-lg"><?php echo e(translate('Experience')); ?></h6>
                    </div>
                </div>

                <div class="p-3 md:p-6">
                    <div class="overflow-x-auto scrollbar-table">
                        <table
                            class="table-auto border-collapse w-full whitespace-nowrap text-sm text-left text-gray-500 dark:text-dark-text font-medium">
                            <thead>
                                <tr class="text-primary-500">
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('Company')); ?>

                                    </th>
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('Role')); ?>

                                    </th>
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('Start Date')); ?>

                                    </th>
                                    <th
                                        class="p-6 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg dk-theme-card-square">
                                        <?php echo e(translate('End Date')); ?>

                                    </th>

                                </tr>
                            </thead>
                            <tbody
                                class="divide-y divide-gray-200 dark:divide-dark-border-three dark:divide-dark-border-three">
                                <?php $__currentLoopData = $user->experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="p-6 py-4"><?php echo e($experience->name ?? ''); ?></td>
                                        <td class="p-6 py-4"><?php echo e($experience?->pivot?->designation ?? ''); ?></td>
                                        <td class="p-6 py-4"><?php echo e($experience?->pivot?->start_date ?? ''); ?></td>
                                        <td class="p-6 py-4">
                                            <?php echo e($experience?->pivot?->end_date ? $experience?->pivot?->end_date : translate('Currently Working')); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        <?php endif; ?>
    </div>
    <!-- End Account Setting Form -->
    <!-- Start Profile View -->
    <div class="col-span-full sm:col-span-6 xl:col-span-4">
        <?php if (isset($component)) { $__componentOriginala60307fc09e0235f850a89cada904ff7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala60307fc09e0235f850a89cada904ff7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.user-profile','data' => ['user' => $user,'guard' => ''.e($user->guard).'','translations' => $translations]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.user-profile'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['user' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($user),'guard' => ''.e($user->guard).'','translations' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($translations)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala60307fc09e0235f850a89cada904ff7)): ?>
<?php $attributes = $__attributesOriginala60307fc09e0235f850a89cada904ff7; ?>
<?php unset($__attributesOriginala60307fc09e0235f850a89cada904ff7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala60307fc09e0235f850a89cada904ff7)): ?>
<?php $component = $__componentOriginala60307fc09e0235f850a89cada904ff7; ?>
<?php unset($__componentOriginala60307fc09e0235f850a89cada904ff7); ?>
<?php endif; ?>
    </div>
    <!-- End Profile View -->
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\admin\profile-detail.blade.php ENDPATH**/ ?>