<?php
    $courses = $courses ?? [];
    $courseCategories = $courseCategories ?? [];
?>

<div class="bg-section relative py-16 sm:py-24 lg:py-[120px] mt-16 sm:mt-24 lg:mt-[120px]">
    <div class="container">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full md:col-span-6">
                <div class="area-subtitle subtitle-outline style-three !text-secondary">
                    <?php echo e(translate('Online Courses')); ?></div>
                <h2 class="area-title mt-1">
                    <?php echo e(translate('Best Online Courses')); ?>

                </h2>
            </div>
            <?php if(!empty($courseCategories) && is_iterable($courseCategories)): ?>
                <div class="col-span-full md:col-span-6 justify-self-end">
                    <div class="dashkit-tab flex items-center flex-wrap gap-1" id="onlineCourseTab">
                        <button
                            type="button"
                            aria-label="Online course category tab"
                            class="dashkit-tab-btn btn hover:bg-secondary hover:text-white [&.active]:bg-secondary [&.active]:text-white capitalize active"
                            id="all-courses"><?php echo e(translate('All')); ?></button>
                        <?php $__currentLoopData = $courseCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $categoryTranslations = parse_translation($courseCategory); ?>
                            <button
                                type="button"
                                aria-label="Online course category tab"
                                class="dashkit-tab-btn btn hover:bg-secondary hover:text-white [&.active]:bg-secondary [&.active]:text-white capitalize"
                                id="<?php echo e($courseCategory->slug); ?>"><?php echo e($categoryTranslations['title'] ?? $courseCategory->title ?? ''); ?>

                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <!-- BODY -->
        <?php if(!empty($courses) && is_iterable($courses)): ?>
            <div class="mt-[60px]">
                <div class="dashkit-tab-content *:hidden" id="onlineCourseTabContent">
                    <div class="dashkit-tab-pane !block" data-tab="all-courses">
                        <div class="grid grid-cols-12 gap-x-4 xl:gap-x-7 gap-y-7">
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if (isset($component)) { $__componentOriginale3f6f030cd740c73bb20a6dec162bcfa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.course.card-four','data' => ['course' => $course,'tab' => 'all-courses']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.course.card-four'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['course' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($course),'tab' => 'all-courses']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa)): ?>
<?php $attributes = $__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa; ?>
<?php unset($__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale3f6f030cd740c73bb20a6dec162bcfa)): ?>
<?php $component = $__componentOriginale3f6f030cd740c73bb20a6dec162bcfa; ?>
<?php unset($__componentOriginale3f6f030cd740c73bb20a6dec162bcfa); ?>
<?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php $__currentLoopData = $courseCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="dashkit-tab-pane" data-tab="<?php echo e($courseCategory->slug); ?>">
                            <?php $count = 0; ?>
                            <div class="grid grid-cols-12 gap-x-4 xl:gap-x-7 gap-y-7">
                                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($course?->category?->slug === $courseCategory->slug): ?>
                                        <?php $count++; ?>
                                        <?php if (isset($component)) { $__componentOriginale3f6f030cd740c73bb20a6dec162bcfa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.course.card-four','data' => ['course' => $course,'tab' => ''.e($courseCategory->slug).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.course.card-four'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['course' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($course),'tab' => ''.e($courseCategory->slug).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa)): ?>
<?php $attributes = $__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa; ?>
<?php unset($__attributesOriginale3f6f030cd740c73bb20a6dec162bcfa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale3f6f030cd740c73bb20a6dec162bcfa)): ?>
<?php $component = $__componentOriginale3f6f030cd740c73bb20a6dec162bcfa; ?>
<?php unset($__componentOriginale3f6f030cd740c73bb20a6dec162bcfa); ?>
<?php endif; ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <?php if(0 === $count): ?>
                                <div class="bg-white border border-border rounded-xl h-[400px] shadow-md">
                                    <div
                                        class="flex-center flex-col gap-4 p-6 text-center max-w-screen-sm mx-auto h-full">
                                        <h2 class="area-title xl:text-3xl"><?php echo e(translate('Oops, Nothing Here Yet!')); ?>

                                        </h2>
                                        <p class="area-description">
                                            <?php echo e(translate("It looks like we don't have any courses in this category right now. Feel free to browse other categories or let us know if there's something specific you'd like to learn!")); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php else: ?>
            <div class="mt-[60px] bg-white border border-border rounded-xl h-[400px] shadow-md">
                <div class="flex-center flex-col gap-4 p-6 text-center max-w-screen-sm mx-auto h-full">
                    <h2 class="area-title xl:text-3xl"><?php echo e(translate('Oops, Nothing Here Yet!')); ?></h2>
                    <p class="area-description">
                        <?php echo e(translate("It looks like we don't have any courses right now. Feel free to browse other or let us know if there's something specific you'd like to learn!")); ?>

                    </p>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\themes\digital-education\components\course\best-online-course.blade.php ENDPATH**/ ?>