<?php
    $backendSetting = get_theme_option(key: 'backend_general') ?? null;
?>
<!DOCTYPE html>
<html lang="en" class="group" data-sidebar-size="lg">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo e(isset($backendSetting['app_name']) ? $backendSetting['app_name'] . ' -' : null); ?> <?php echo e($title ?? null); ?></title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="web development agency">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" id="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php
        $backendLogo = get_theme_option(key: 'backend_logo') ?? null;
    ?>
    <?php if(isset($backendLogo['favicon']) && fileExists($folder = 'lms/theme-options', $fileName = $backendLogo['favicon']) == true && $backendLogo['favicon'] !== ''): ?>
        <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('storage/lms/theme-options/' . $backendLogo['favicon'])); ?>">
    <?php else: ?>
        <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('lms/frontend/assets/images/favicon.ico')); ?>">
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(asset('lms/assets/css/vendor/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lms/assets/css/vendor/flatpickr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lms/assets/css/vendor/summernote.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lms/assets/css/vendor/select/select2.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('lms/assets/css/output.min.css?v=' . asset_version('lms/assets/css/output.min.css'))); ?>" />

    <?php echo $__env->yieldPushContent('css'); ?>
</head>

<body class="bg-body-light dark:bg-dark-body group-data-[theme-width=box]:container group-data-[theme-width=box]:max-w-screen-3xl xl:group-data-[theme-width=box]:px-4">
    <div id="preloader" class="dark:!bg-dark-body">
        <div id="status">
            <div class="spinner">
                <div class="rect1"></div>
                <div class="rect2"></div>
                <div class="rect3"></div>
                <div class="rect4"></div>
                <div class="rect5"></div>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbc9ed3e6478895fcb56cbed594604061 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbc9ed3e6478895fcb56cbed594604061 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.header','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbc9ed3e6478895fcb56cbed594604061)): ?>
<?php $attributes = $__attributesOriginalbc9ed3e6478895fcb56cbed594604061; ?>
<?php unset($__attributesOriginalbc9ed3e6478895fcb56cbed594604061); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbc9ed3e6478895fcb56cbed594604061)): ?>
<?php $component = $__componentOriginalbc9ed3e6478895fcb56cbed594604061; ?>
<?php unset($__componentOriginalbc9ed3e6478895fcb56cbed594604061); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginal306384c77c5e3eeb203cb44221411c3a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal306384c77c5e3eeb203cb44221411c3a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal306384c77c5e3eeb203cb44221411c3a)): ?>
<?php $attributes = $__attributesOriginal306384c77c5e3eeb203cb44221411c3a; ?>
<?php unset($__attributesOriginal306384c77c5e3eeb203cb44221411c3a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal306384c77c5e3eeb203cb44221411c3a)): ?>
<?php $component = $__componentOriginal306384c77c5e3eeb203cb44221411c3a; ?>
<?php unset($__componentOriginal306384c77c5e3eeb203cb44221411c3a); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginal34e97fb287194ca60842d629b70ed660 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal34e97fb287194ca60842d629b70ed660 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.settings-sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.settings-sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal34e97fb287194ca60842d629b70ed660)): ?>
<?php $attributes = $__attributesOriginal34e97fb287194ca60842d629b70ed660; ?>
<?php unset($__attributesOriginal34e97fb287194ca60842d629b70ed660); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal34e97fb287194ca60842d629b70ed660)): ?>
<?php $component = $__componentOriginal34e97fb287194ca60842d629b70ed660; ?>
<?php unset($__componentOriginal34e97fb287194ca60842d629b70ed660); ?>
<?php endif; ?>

    <!-- Start Main Content -->
    <main class="main-content group-data-[sidebar-size=lg]:xl:ml-[calc(theme('spacing.app-menu')_+_16px)] rtl:group-data-[sidebar-size=lg]:xl:ml-0 rtl:group-data-[sidebar-size=lg]:xl:mr-[calc(theme('spacing.app-menu')_+_16px)] group-data-[sidebar-size=sm]:xl:ml-[calc(theme('spacing.app-menu-sm')_+_16px)] rtl:group-data-[sidebar-size=sm]:xl:ml-0 rtl:group-data-[sidebar-size=sm]:xl:mr-[calc(theme('spacing.app-menu-sm')_+_16px)] px-4 group-data-[theme-width=box]:xl:px-0 duration-300">
        <?php echo e($slot); ?>

    </main>
    <!-- End Main Content -->

    <?php if (isset($component)) { $__componentOriginal75a5028c89fe16e09e447f8b099457a4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal75a5028c89fe16e09e447f8b099457a4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.ai.modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.ai.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal75a5028c89fe16e09e447f8b099457a4)): ?>
<?php $attributes = $__attributesOriginal75a5028c89fe16e09e447f8b099457a4; ?>
<?php unset($__attributesOriginal75a5028c89fe16e09e447f8b099457a4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal75a5028c89fe16e09e447f8b099457a4)): ?>
<?php $component = $__componentOriginal75a5028c89fe16e09e447f8b099457a4; ?>
<?php unset($__componentOriginal75a5028c89fe16e09e447f8b099457a4); ?>
<?php endif; ?>

    <?php echo $__env->make('portal::admin.placeholder', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(auth()->guard()->check()): ?>
        <?php if(Auth::user()->guard == 'instructor'): ?>
            <input type="hidden" id="baseUrl" value="<?php echo e(route('instructor.dashboard')); ?>" />
        <?php elseif(Auth::user()->guard == 'organization'): ?>
            <input type="hidden" id="baseUrl" value="<?php echo e(route('organization.dashboard')); ?>" />
        <?php else: ?>
            <input type="hidden" id="baseUrl" value="<?php echo e(route('admin.dashboard')); ?>" />
        <?php endif; ?>
    <?php endif; ?>

    <script src="<?php echo e(asset('lms/assets/js/vendor/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lms/assets/js/vendor/flowbite.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lms/assets/js/vendor/smooth-scrollbar/smooth-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lms/assets/js/vendor/summernote.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lms/assets/js/vendor/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lms/assets/js/vendor/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lms/assets/js/vendor/flatpickr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lms/assets/js/vendor/sweetalert2.js')); ?>"></script>
    <script>
        let baseUrl = $("#baseUrl").val();
        const textAreaPlaceholder = "<?php echo e(translate('Write your description here')); ?>";
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    <script src="<?php echo e(edulab_asset('lms/assets/js/component/switcher.js')); ?>"></script>
    <script src="<?php echo e(edulab_asset('lms/assets/js/component/modal.js')); ?>"></script>
    <script src="<?php echo e(edulab_asset('lms/assets/js/component/ai-modal.js')); ?>"></script>
    <script src="<?php echo e(edulab_asset('lms/assets/js/tab.js')); ?>"></script>
    <script src="<?php echo e(edulab_asset('lms/assets/js/custom.js')); ?>"></script>
    <script src="<?php echo e(edulab_asset('lms/assets/js/layout.js')); ?>"></script>
    <script src="<?php echo e(edulab_asset('lms/assets/js/main.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\layouts\app.blade.php ENDPATH**/ ?>