<?php
    $backendSetting = get_theme_option(key: 'backend_general') ?? [];
    $logo = $data['logo_options'] ?? get_theme_option(key: 'theme_logo');

    $defaultFavIcon =
        isset($logo['favicon']) && fileExists('lms/theme-options', $logo['favicon']) == true
            ? asset("storage/lms/theme-options/{$logo['favicon']}")
            : asset('lms/frontend/assets/images/favicon.svg');
    $favIcon = $data['fav_icon'] ?? $defaultFavIcon;

    $customScript = get_theme_option('custom_script') ?? [];
    $customCss = $customScript['custom_css'] ?? '';
    $customJs = $customScript['custom_js'] ?? '';
?>

<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale() ?? app('default_language')); ?>" class="group" dir="<?php echo e(active_rtl()); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo e($backendSetting['app_name'] ?? translate('Edulab LMS')); ?></title>
    <meta name="description" content="web development agency">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e($favIcon); ?>">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Mulish:ital,wght@0,200..1000;1,200..1000&family=Public+Sans:ital,wght@0,100..900;1,100..900&display=swap">
    <?php echo $__env->yieldPushContent('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('lms/assets/css/vendor/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lms/frontend/assets/vendor/css/swiper-bundle.min.css')); ?>">
    <script src="<?php echo e(asset('lms/frontend/assets/vendor/js/lozad.min.js')); ?>"></script>
    <link rel="stylesheet"
        href="<?php echo e(asset('lms/frontend/assets/css/output.min.css?v=' . asset_version('lms/frontend/assets/css/output.min.css'))); ?>">
    <?php if($customCss): ?>
        <style>
            <?php echo $customCss; ?>

        </style>
    <?php endif; ?>
</head>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\theme\layouts\partials\head.blade.php ENDPATH**/ ?>