<?php if(!empty($courses)): ?>
    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $translations = parse_translation($course);
            $categoryTranslations = parse_translation($course->category);
            $reviews = review($course);

            $imagePath = 'lms/courses/thumbnails';
            $defaultThumbnail = 'lms/frontend/assets/images/420x252.svg';
            $thumbnail =
                !empty($course?->thumbnail) && fileExists($imagePath, $course->thumbnail)
                    ? asset('storage/' . $imagePath . '/' . $course->thumbnail)
                    : asset($defaultThumbnail);

            $randomKey = random_string(2);
            $currency = $course?->coursePrice->currency ?? 'USD-$';
            $currencySymbol = get_currency_symbol($currency);
        ?>

        <!-- COURSE CARD -->
        <div class="swiper-slide col-span-full md:col-span-6 xl:col-span-4 group-data-[card-layout=list]:!col-span-full">
            <div
                class="flex flex-col bg-white rounded-2xl h-full p-5 group-data-[card-layout=list]:flex-row [&.card-border]:border [&.card-border]:border-border [&.card-border]:hover:shadow-md custom-transition group/course <?php echo e(isset($borderClass) ? 'card-border' : ''); ?>">
                <!-- COURSE THUMBNAIL -->
                <div class="relative aspect-video rounded-xl overflow-hidden">
                    <img data-src="<?php echo e($thumbnail); ?>"
                        class="course-grid-thumb-img w-full group-hover/topCourse:scale-110 duration-300"
                        alt="Course thumbnail" />
                    <!-- badge -->
                    <?php $__currentLoopData = $course->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $levelTranslations = parse_translation($level); ?>
                        <span
                            class="badge b-solid badge-secondary-solid rounded-full !text-heading dark:text-white absolute top-4 left-4 rtl:left-auto rtl:right-4 z-10"><?php echo e($levelTranslations['name'] ?? ($level->name ?? '')); ?>

                        </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if(auth()->guard()->check()): ?>
                        <?php
                            $class = user_wishlist_check($course->id) ? 'active' : '';
                        ?>
                        <label for="course_<?php echo e($course->id . '' . $randomKey); ?>"
                            class="flex-center absolute top-3 right-4 rtl:right-auto rtl:left-4 size-11 rounded-50 bg-white cursor-pointer select-none z-[1] add-wishlist group/wishlist <?php echo e($class); ?>"
                            data-id="<?php echo e($course->id); ?>">
                            <input type="checkbox" id="course_<?php echo e($course->id . '' . $randomKey); ?>"
                                class="appearance-none before:font-remix before:content-['\eae5'] before:text-heading before:text-xl group-[.active]/wishlist:before:content-['\eae4'] cursor-pointer">
                        </label>
                    <?php else: ?>
                        <label for="course_<?php echo e($course->id . '' . $randomKey); ?>"
                            class="flex-center absolute top-3 right-4 rtl:right-auto rtl:left-4 size-11 rounded-50 bg-white cursor-pointer select-none z-[1]"
                            data-id="<?php echo e($course->id); ?>">
                            <a href="<?php echo e(route('auth.login')); ?>" id="course_<?php echo e($course->id . '' . $randomKey); ?>"
                                class="appearance-none before:font-remix before:content-['\eae5'] before:text-heading before:text-xl checked:before:content-['\eae4'] cursor-pointer">
                            </a>
                        </label>
                    <?php endif; ?>

                    <!-- ADD TO WISHLIST -->

                </div>
                <!-- COURSE CONTENT -->
                <div class="mt-6 group-data-[card-layout=list]:mt-0 group-data-[card-layout=list]:ml-6">
                    <div class="flex-center-between">
                        <div class="badge badge-heading-outline b-outline rounded-full shrink-0">
                            <?php echo e($categoryTranslations['title'] ?? ($course?->category?->title ?? '')); ?></div>
                        <?php if($course?->courseSetting?->is_free): ?>
                            <div
                                class="text-primary text-xl !leading-none font-bold text-right shrink-0 flex items-center gap-1.5">
                                <span><?php echo e(translate('Free')); ?></span>
                            </div>
                        <?php else: ?>
                            <div
                                class="text-primary text-xl !leading-none font-bold text-right shrink-0 flex items-center gap-1.5">
                                <?php if(isset($course?->coursePrice) &&
                                        $course?->coursePrice?->discount_flag == 1 &&
                                        $course?->coursePrice?->discount_period != '' &&
                                        dateCompare($course?->coursePrice?->discount_period) == true): ?>
                                    <span> <?php echo e($course?->coursePrice->currency); ?>

                                        <?php echo e(dotZeroRemove($course?->coursePrice?->discounted_price ?? 0)); ?></span>
                                    <span>
                                        <del
                                            class="text-heading/50 text-[16px] font-semibold"><?php echo e($currencySymbol); ?><?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?></del>
                                    </span>
                                <?php else: ?>
                                    <span><?php echo e($currencySymbol); ?><?php echo e(dotZeroRemove($course?->coursePrice?->price ?? 0)); ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <h6 class="area-title font-bold !text-xl mt-3 group-hover/course:text-primary custom-transition">
                        <a href="<?php echo e(route('course.detail', $course->slug)); ?>" class="line-clamp-2"
                            aria-label="Course title"><?php echo e($translations['title'] ?? ($course->title ?? '')); ?></a>
                    </h6>

                    <?php if(!isset($isComing)): ?>
                        <div class="flex items-center gap-2 mt-3">
                            <div class="flex items-center gap-0.5 text-secondary">
                                <?php echo show_rating($reviews['average_rating']); ?>

                            </div>
                            <p class="area-description text-sm !leading-none">
                                (<?php echo e(dotZeroRemove($reviews['average_rating']) ?? 0); ?> <?php echo e(translate('Rating')); ?>)
                            </p>
                        </div>
                    <?php endif; ?>

                    <div class="flex-center-between gap-2 pt-4 mt-6 border-t border-heading/10">
                        <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                            <i class="ri-time-line"></i>
                            <span><?php echo e($course->duration); ?></span>
                        </div>
                        <div class="flex items-center gap-4 shrink-0">
                            <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                                <i class="ri-book-line"></i>
                                <span><?php echo e($course?->chapters?->count() ?? 0); ?> <?php echo e(translate('Lessons')); ?> </span>
                            </div>
                            <?php if(!isset($isComing)): ?>
                                <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                                    <i class="ri-group-line"></i>
                                    <span> <?php echo e($course?->totalPurchases?->count() ?? 0); ?> <?php echo e(translate('Student')); ?>

                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\course-card-one.blade.php ENDPATH**/ ?>