<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Application Installer</title>

    <?php if(!alreadyInstalled()): ?>
        <?php if(indexFile() == true): ?>
            <!-- style css -->
            <link rel="stylesheet" href="<?php echo e(edulab_asset('installer/assets/css/style.css')); ?>">
        <?php else: ?>
            <?php if(env('ASSET_URL') !== null): ?>
                <link rel="stylesheet" href="<?php echo e(edulab_asset('installer/assets/css/style.css')); ?>">
            <?php else: ?>
                <link rel="stylesheet" href="<?php echo e(edulab_asset('public/installer/assets/css/style.css')); ?>">
            <?php endif; ?>

        <?php endif; ?>
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(edulab_asset('installer/assets/css/style.css')); ?>">
    <?php endif; ?>
</head>

<body>

    <?php echo $__env->yieldContent('content'); ?>

    <?php if(!alreadyInstalled()): ?>
        <?php
            $prefix = indexFile() || env('ASSET_URL') !== null ? '' : 'public/';
        ?>
    <?php else: ?>
        <?php
            $prefix = '';
        ?>
    <?php endif; ?>
    <script src="<?php echo e(asset($prefix . 'installer/assets/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset($prefix . 'installer/assets/js/js-confetti.browser.js')); ?>"></script>
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    <script src="<?php echo e(edulab_asset($prefix . 'installer/assets/js/main.js')); ?>"></script>

    <?php if(request()->is('/')): ?>
        <script>
            window.location.replace(`install`);
        </script>
    <?php endif; ?>
    <?php if(request()->is('install/final')): ?>
        <script>
            const canvas = document.getElementById('custom_canvas');
            const jsConfetti = new JSConfetti({
                canvas
            })
            jsConfetti.addConfetti();
        </script>
    <?php endif; ?>
</body>

</html>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\installer\layout.blade.php ENDPATH**/ ?>