<?php 
    $courses = $courses ?? [];
    $courseCategories = $courseCategories ?? [];
?>

<div class="relative py-16 sm:py-24 lg:py-[120px] bg-gradient-to-b from-[#FEFBF0] to-[#E6F3EB] mt-16 sm:mt-24 lg:mt-[120px] overflow-hidden">
    <div class="container relative z-[1]">
        <!-- HEADER -->
        <div class="grid grid-cols-12 gap-4 items-center">
            <div class="col-span-full text-center max-w-[670px] mx-auto">
                <h2 class="area-title">
                    <?php echo e(translate( 'We Engage Kids at Their Level, No Matter' )); ?>

                    <span class="title-highlight-two"><?php echo e(translate( 'Their Stage' )); ?></span>
                </h2>
            </div>
        </div>
        <!-- BODY -->
        <?php if( count( $courses ) > 0 ): ?>
            <div class="swiper child-course-slider mt-10 lg:mt-[60px]">
                <div class="swiper-wrapper">
                    <!-- SINGLE CHILD COURSE CARD -->
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <?php if (isset($component)) { $__componentOriginal28ca31235ed7de3d0a61e2c73313a2f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal28ca31235ed7de3d0a61e2c73313a2f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::cards.course.card-five','data' => ['course' => $course]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::cards.course.card-five'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['course' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($course)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal28ca31235ed7de3d0a61e2c73313a2f9)): ?>
<?php $attributes = $__attributesOriginal28ca31235ed7de3d0a61e2c73313a2f9; ?>
<?php unset($__attributesOriginal28ca31235ed7de3d0a61e2c73313a2f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal28ca31235ed7de3d0a61e2c73313a2f9)): ?>
<?php $component = $__componentOriginal28ca31235ed7de3d0a61e2c73313a2f9; ?>
<?php unset($__componentOriginal28ca31235ed7de3d0a61e2c73313a2f9); ?>
<?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <!-- SWIPER PAGINATION -->
            <div class="flex-center mt-10 lg:mt-[60px]">
                <div class="child-course-pagination swiper-custom-pagination"></div>
            </div>
        <?php endif; ?>
    </div>
    <!-- POSITIONAL ELEMENT -->
    <ul>
        <!-- TOP LEFT -->
        <li class="block size-[29vw] rounded-50 bg-[#D2EB1A]/15 blur-[200px] absolute top-0 xl:-top-20 left-0 xl:-left-20"></li>
        <li class="absolute top-32 left-[10%]"><img data-src="<?php echo e(asset( 'lms/frontend/assets/images/icons/triangle.svg' )); ?>" alt="triangle"></li>
        <!-- TOP RIGHT -->
        <li class="block size-[29vw] rounded-50 bg-[#B326F4]/15 blur-[200px] absolute top-0 xl:-top-20 right-0 xl:-right-20"></li>
        <li class="absolute top-32 right-[17%]"><img data-src="<?php echo e(asset('lms/frontend/assets/images/icons/role-ab.svg')); ?>" alt="role-ab"></li>
        <!-- BOTTOM RIGHT -->
        <li class="absolute bottom-32 right-[12%]"><img data-src="<?php echo e(asset('lms/frontend/assets/images/icons/compas.svg')); ?>" alt="compass"></li>
    </ul>
</div><?php /**PATH D:\www\edulab\Modules\LMS\resources\themes\kindergarten\components\course\kid-course.blade.php ENDPATH**/ ?>