<?php
    $thumbnail =
        $enrolled?->course?->thumbnail && fileExists('lms/courses/thumbnails', $enrolled?->course?->thumbnail) == true
            ? asset('storage/lms/courses/thumbnails/' . $enrolled?->course?->thumbnail)
            : asset('lms/assets/images/placeholder/thumbnail612.jpg');
    $courseTranslations = parse_translation($enrolled?->course);
    $categoryTranslations = parse_translation($enrolled?->course?->category);
    $subjectTranslations = parse_translation($enrolled?->course?->subject);
    $currency = $enrolled?->course?->coursePrice?->currency ?? 'USD-$';
    $currencySymbol = get_currency_symbol($currency);
?>
<tr>
    <td class="px-3.5 py-4">
        <div class="flex items-center gap-2">
            <a href="#" class="size-[70px] rounded-50 overflow-hidden dk-theme-card-square">
                <img src="<?php echo e($thumbnail); ?>" alt="thumb" class="size-full object-cover">
            </a>
            <div>
                <h6 class="text-lg leading-none text-heading dark:text-white font-bold mb-1.5 line-clamp-1">
                    <a href="<?php echo e(route('course.detail', $enrolled?->course?->slug)); ?>" target="_blank">
                        <?php echo e($courseTranslations['title'] ?? $enrolled?->course?->title); ?></a>
                </h6>
                <div class="flex items-center gap-2">
                    <?php if(isset($enrolled?->course?->instructors)): ?>
                        <p class="font-normal text-xs text-gray-900">
                            <?php echo e(translate('Instructor')); ?> -
                            <?php $__currentLoopData = $enrolled->course->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $userTranslations = parse_translation($instructor?->userable);
                                ?>
                                <?php echo e($userTranslations['first_name'] ?? $instructor?->userable?->first_name); ?>

                                <?php echo e($userTranslations['last_name'] ?? $instructor?->userable?->last_name); ?>

                                <?php if(!$loop->last): ?>
                                    <?php echo e(','); ?>

                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </td>
    <td class="px-3.5 py-4">
        <ul class="flex flex-col gap-2">
            <?php if($enrolled?->course?->category?->title): ?>
                <li class="flex items-center gap-1">
                    <b> <?php echo e(translate('Category')); ?> :</b>
                    <span><?php echo e($categoryTranslations['title'] ?? $enrolled?->course?->category?->title); ?></span>
                </li>
            <?php endif; ?>

            <?php if($enrolled?->subject): ?>
                <li class="flex items-center gap-1">
                    <b> <?php echo e(translate('Subject')); ?> :</b>
                    <span><?php echo e($subjectTranslations['name'] ?? $enrolled?->course?->subject?->name); ?></span>
                </li>
            <?php endif; ?>
        </ul>
    </td>
    <td class="px-3.5 py-4">
        <?php if($enrolled?->course?->courseSetting?->is_free): ?>
            <?php echo e(translate('Free')); ?>

        <?php else: ?>
            <?php echo e($currencySymbol); ?><?php echo e($enrolled?->course?->coursePrice?->price); ?>

        <?php endif; ?>
    </td>
    <td class="px-3.5 py-4">
        <?php switch($enrolled->status):
            case ('processing'): ?>
                <span class="badge badge-warning-outline b-outline capitalize">
                    <?php echo e(translate('Processing')); ?>

                </span>
            <?php break; ?>

            <?php case ('complete'): ?>
                <span class="badge badge-primary-outline b-outline capitalize">
                    <?php echo e(translate('Complete')); ?>

                </span>
            <?php break; ?>
        <?php endswitch; ?>
    </td>
</tr>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\student\enrolled-course.blade.php ENDPATH**/ ?>